/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;
import javax.swing.border.Border;

public class AnimatedBorder
implements Border {
    private float phase = 0.0f;
    private float incrementer = 1.0f;
    private boolean animating = true;
    private final float[] dashArray = new float[]{20.0f, 10.0f};
    private final Component component;
    private final Color borderColor;

    public AnimatedBorder(Component component, Color borderColor, boolean goingLeft) {
        this.component = component;
        this.borderColor = borderColor;
        if (goingLeft) {
            this.phase = 300000.0f;
            this.incrementer = -1.0f;
        }
        Timer animationTimer = new Timer(50, e -> {
            if (component.isShowing()) {
                this.phase += this.incrementer;
                component.repaint();
            }
        });
        animationTimer.start();
        new Timer(30000, e -> {
            animationTimer.stop();
            this.animating = false;
            component.repaint();
        }).start();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g.create();
        AffineTransform at = g2d.getTransform();
        double scaleX = at.getScaleX();
        if (scaleX == 0.0) {
            scaleX = 1.0;
        }
        float onePhysicalPixel = 1.0f / (float)scaleX;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2d.setColor(this.borderColor);
        double offset = (double)onePhysicalPixel / 2.0;
        double safetyGap = 0.1;
        Rectangle2D.Double rect = new Rectangle2D.Double((double)x + offset, (double)y + offset, (double)((float)width - onePhysicalPixel) - safetyGap, (double)((float)height - onePhysicalPixel) - safetyGap);
        if (this.animating) {
            BasicStroke stroke = new BasicStroke(onePhysicalPixel, 0, 0, 10.0f, this.dashArray, this.phase);
            g2d.setStroke(stroke);
        } else {
            g2d.setStroke(new BasicStroke(onePhysicalPixel, 0, 0));
        }
        g2d.draw(rect);
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

